/*
 * Decompiled with CFR 0.152.
 */
package net.hecco.bountifulfares.block.custom;

import net.hecco.bountifulfares.block.BFBlocks;
import net.hecco.bountifulfares.trellis.BFTrellises;
import net.hecco.bountifulfares.trellis.TrellisUtil;
import net.hecco.bountifulfares.trellis.trellis_parts.TrellisVariant;
import net.hecco.bountifulfares.trellis.trellis_parts.VineCrop;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CropTrellisBlock
extends Block
implements SimpleWaterloggedBlock,
BonemealableBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final DirectionProperty FACING;
    public static final IntegerProperty AGE;
    private final Item berryItem;
    protected static final VoxelShape NORTH_SHAPE;
    protected static final VoxelShape SOUTH_SHAPE;
    protected static final VoxelShape WEST_SHAPE;
    protected static final VoxelShape EAST_SHAPE;
    public static BooleanProperty SNIPPED;
    private final TrellisVariant variant;
    private final VineCrop crop;
    private String berryItemID;
    private final int harvestResetAge;

    public CropTrellisBlock(Item berryItem, TrellisVariant variant, VineCrop crop, BlockBehaviour.Properties settings) {
        super(settings);
        this.berryItem = berryItem;
        BFBlocks.CROPS_TO_CROP_TRELLISES.put(berryItem, this);
        this.variant = variant;
        this.crop = crop;
        this.harvestResetAge = 1;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)SNIPPED, (Comparable)Boolean.valueOf(false)));
    }

    public CropTrellisBlock(int harvestResetAge, String berryItemID, TrellisVariant variant, VineCrop crop, BlockBehaviour.Properties settings) {
        super(settings);
        this.berryItem = null;
        this.berryItemID = berryItemID;
        this.variant = variant;
        this.crop = crop;
        this.harvestResetAge = harvestResetAge;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)SNIPPED, (Comparable)Boolean.valueOf(false)));
    }

    public CropTrellisBlock(Item seedsItem, Item berryItem, TrellisVariant variant, VineCrop crop, BlockBehaviour.Properties settings) {
        super(settings);
        this.berryItem = berryItem;
        BFBlocks.CROPS_TO_CROP_TRELLISES.put(seedsItem, this);
        this.variant = variant;
        this.crop = crop;
        this.harvestResetAge = 1;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)SNIPPED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.m_61143_((Property)FACING)) {
            case NORTH: {
                return NORTH_SHAPE;
            }
            case SOUTH: {
                return SOUTH_SHAPE;
            }
            case WEST: {
                return WEST_SHAPE;
            }
        }
        return EAST_SHAPE;
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        if (!player.m_7500_()) {
            CropTrellisBlock.m_49840_((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)this.crop.getSeedsItem()));
        }
        super.m_5707_(world, pos, state, player);
    }

    public String m_7705_() {
        return "block." + this.variant.getModId() + "." + this.crop.getName() + "_" + this.variant.getBlockName();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED, FACING, AGE, SNIPPED});
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        int i = (Integer)state.m_61143_((Property)AGE);
        if (player.m_21120_(hand).m_150930_(Items.f_42574_) && !((Boolean)state.m_61143_((Property)SNIPPED)).booleanValue()) {
            player.m_21120_(hand).m_41622_(1, (LivingEntity)player, playerx -> playerx.m_21190_(hand));
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)SNIPPED, (Comparable)Boolean.valueOf(true)));
            world.m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12344_, SoundSource.BLOCKS, 1.0f, 1.0f);
            player.m_21120_(hand).m_41622_(1, (LivingEntity)player, playerx -> playerx.m_21190_(hand));
            return InteractionResult.SUCCESS;
        }
        if (i != 3) {
            return InteractionResult.PASS;
        }
        if ((Integer)state.m_61143_((Property)AGE) == 3 & (Boolean)state.m_61143_((Property)SNIPPED) == false) {
            int j = 1 + world.f_46441_.m_188503_(2);
            if (this.berryItem != null) {
                CropTrellisBlock.m_49840_((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)this.berryItem, world.f_46441_.m_216332_(1, 2)));
                world.m_5594_(null, pos, SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 0.8f + world.f_46441_.m_188501_() * 0.4f);
            } else if (this.berryItemID != null) {
                CropTrellisBlock.m_49840_((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(this.crop.getId(), this.berryItemID)), world.f_46441_.m_216332_(1, 2)));
                world.m_5594_(null, pos, SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 0.8f + world.f_46441_.m_188501_() * 0.4f);
            }
            BlockState blockState = (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(this.harvestResetAge));
            world.m_7731_(pos, blockState, 2);
            world.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223719_((Entity)player, (BlockState)blockState));
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (!((Boolean)state.m_61143_((Property)SNIPPED)).booleanValue() && !CropTrellisBlock.isFullyGrown(state) && world.f_46441_.m_188501_() < 0.2f) {
            world.m_7731_(pos, (BlockState)state.m_61122_((Property)AGE), 2);
        }
    }

    public void m_214148_(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        if (!((Boolean)state.m_61143_((Property)SNIPPED)).booleanValue() && !CropTrellisBlock.isFullyGrown(state)) {
            world.m_7731_(pos, (BlockState)state.m_61122_((Property)AGE), 2);
        }
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ctx.m_43725_().m_6425_(ctx.m_8083_()).m_76152_() == Fluids.f_76193_));
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        return super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    public ItemStack m_7397_(BlockGetter world, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)TrellisUtil.getTrellisFromVariant(this.variant));
    }

    public FluidState m_5888_(BlockState state) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            return Fluids.f_76193_.m_76068_(false);
        }
        return super.m_5888_(state);
    }

    public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
        return false;
    }

    public boolean m_7370_(LevelReader world, BlockPos pos, BlockState state, boolean isClient) {
        if (CropTrellisBlock.isFullyGrown(state)) {
            return false;
        }
        return (Boolean)state.m_61143_((Property)SNIPPED) == false;
    }

    public boolean m_214167_(Level world, RandomSource random, BlockPos pos, BlockState state) {
        if (CropTrellisBlock.isFullyGrown(state)) {
            return false;
        }
        return (Boolean)state.m_61143_((Property)SNIPPED) == false;
    }

    protected static boolean isFullyGrown(BlockState state) {
        return (Integer)state.m_61143_((Property)AGE) == 3;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public boolean m_7420_(BlockState state, BlockGetter world, BlockPos pos) {
        return state.m_60819_().m_76178_();
    }

    public static BlockState getCropTrellisFromCrop(Item seedsItem) {
        if (seedsItem != null && BFBlocks.CROPS_TO_CROP_TRELLISES.containsKey(seedsItem)) {
            return BFBlocks.CROPS_TO_CROP_TRELLISES.get(seedsItem).m_49966_();
        }
        return BFTrellises.TRELLISES.get("trellis").m_49966_();
    }

    static {
        AGE = BlockStateProperties.f_61407_;
        NORTH_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
        SOUTH_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
        WEST_SHAPE = Block.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        EAST_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
        SNIPPED = BooleanProperty.m_61465_((String)"snipped");
        FACING = BlockStateProperties.f_61374_;
    }
}

